@extends('layouts.layout-app')
@section('styles')
<!-- Select2 -->
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<style>
    .control-label{
        text-align: right;
    }
    .hide{
        display: none;
    }
    </style>
@endsection
@section('content')
<div class="register-box" style="width: 500px;">
    <div class="card card-outline card-primary">
      <div class="card-header text-center">
        <a href="{{ route('merchant.register') }}" class="h1"><b>{{ config('app.name', 'Laravel') }}</b></a>
      </div>
      <div class="card-body">
        <p class="login-box-msg">{{ __('Register a new membership') }}</p>
        @if ($message = Session::get('success'))
        <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button> 
            <strong>{{ $message }}</strong>
        </div>
        @endif
        @if ($message = Session::get('failed') || $message = Session::get('error'))
        <div class="alert alert-danger alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button> 
            <strong>{{ $message }}</strong>
        </div>
        @endif     
        <form action="{{ route('merchant.doRegister') }}" method="post">
        @csrf
          <div class="input-group mb-3">
            <input id="first_name" type="text" placeholder="First name" class="form-control @error('first_name') is-invalid @enderror" name="first_name" value="{{ old('first_name') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('first_name')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="last_name" type="text" placeholder="Last name" class="form-control @error('last_name') is-invalid @enderror" name="last_name" value="{{ old('last_name') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('last_name')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="email" type="email" placeholder="Email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-envelope"></span>
              </div>
            </div>
            @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="phone" type="text" placeholder="Phone" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('phone')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="address_line_11" type="text" placeholder="Address Line 1" class="form-control @error('address_line_11') is-invalid @enderror" name="address_line_11" value="{{ old('address_line_11') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('address_line_11')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="address_line_12" type="text" placeholder="Address Line 2" class="form-control @error('address_line_12') is-invalid @enderror" name="address_line_12" value="{{ old('address_line_12') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('address_line_12')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="postal_code_1" type="text" placeholder="Postal Code" class="form-control @error('postal_code_1') is-invalid @enderror" name="postal_code_1" value="{{ old('postal_code_1') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('postal_code_1')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="city_1" type="text" placeholder="City" class="form-control @error('city_1') is-invalid @enderror" name="city_1" value="{{ old('city_1') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('city_1')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="state_1" type="text" placeholder="State" class="form-control @error('state_1') is-invalid @enderror" name="state_1" value="{{ old('state_1') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('state_1')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="country_1" type="text" placeholder="Country" class="form-control @error('country_1') is-invalid @enderror" name="country_1" value="{{ old('country_1') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('country_1')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="address_line_21" type="text" placeholder="Address Line 1" class="form-control @error('address_line_21') is-invalid @enderror" name="address_line_21" value="{{ old('address_line_21') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('address_line_21')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="address_line_22" type="text" placeholder="Address Line 2" class="form-control @error('address_line_22') is-invalid @enderror" name="address_line_22" value="{{ old('address_line_22') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('address_line_22')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="postal_code_2" type="text" placeholder="Postal Code" class="form-control @error('postal_code_2') is-invalid @enderror" name="postal_code_2" value="{{ old('postal_code_2') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('postal_code_2')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="city_2" type="text" placeholder="City" class="form-control @error('city_2') is-invalid @enderror" name="city_2" value="{{ old('city_2') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('city_2')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="state_2" type="text" placeholder="State" class="form-control @error('state_2') is-invalid @enderror" name="state_2" value="{{ old('state_2') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('state_2')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="country_2" type="text" placeholder="Country" class="form-control @error('country_2') is-invalid @enderror" name="country_2" value="{{ old('country_2') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('country_2')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          
          <div class="input-group mb-3">
            <input id="ssm_number" type="text" placeholder="SSM Number" class="form-control @error('ssm_number') is-invalid @enderror" name="ssm_number" value="{{ old('ssm_number') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('ssm_number')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="company_name" type="text" placeholder="Company Name" class="form-control @error('company_name') is-invalid @enderror" name="company_name" value="{{ old('company_name') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('company_name')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="company_email" type="email" placeholder="Company Email" class="form-control @error('company_email') is-invalid @enderror" name="company_email" value="{{ old('company_email') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('company_email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="company_phone" type="text" placeholder="Company Phone" class="form-control @error('company_phone') is-invalid @enderror" name="company_phone" value="{{ old('company_phone') }}" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('company_phone')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input type="file" name="logo" id="logo" class="form-control" accept="image/*" required>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('logo')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <select id="product_category" name="product_category[]" data-placeholder="Select Product Category" class="form-control select2" multiple="multiple" style="width: 100%;" required>
                <option value="0" selected> {{ __('all') }} </option>
                @foreach($product_category as $category)
                    <option value="{{$category->id}}">{{$category->name}}</option>
                @endforeach
            </select>            
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('product_category')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <div class="input-group hdtuto control-group increment" >
              <input type="file" name="product_images[]" class="form-control" accept="image/*" required>
            
              <div class="input-group-btn"> 
                <button class="btn add-image btn-success" type="button"><i class="fldemo fa fa-plus"></i></button>
              </div>
            </div>
          </div>
          <div class="clone hide">
            <div class="hdtuto control-group input-group" style="margin-top:10px">
              <input type="file" name="product_images[]" class=" form-control" accept="image/*">
              <div class="input-group-btn"> 
                <button class="btn btn-danger remove-image" type="button"><i class="fldemo fa fa-trash"></i> </button>
              </div>
            </div>
          </div>
            
            @error('product_images')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          {{-- <div class="input-group mb-3">
            <input type="text" class="form-control" name="commercial_address" id="commercial_address" placeholder="Commercial Address" required/>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('commercial_address')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div> --}}
          {{-- <div class="input-group mb-3">
            <input type="text" class="form-control" name="business_registered_address" id="business_registered_address" placeholder="Business Registered Address" required/>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('business_registered_address')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div> --}}
          <div class="input-group mb-3">
            <input type="text" class="form-control" name="no_of_sales_person" id="no_of_sales_person" placeholder="No of Sales Person" required/>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
            @error('no_of_sales_person')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="password" type="password" placeholder="Password" class="form-control @error('password') is-invalid @enderror" name="password" required>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
            @error('password')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
          </div>
          <div class="input-group mb-3">
            <input id="password_confirm" type="password" placeholder="Retype password" class="form-control" name="password_confirm" required>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-8">
              <div class="icheck-primary">
                <input type="checkbox" id="agreeTerms" name="terms" value="agree">
                <label for="agreeTerms">
                 I agree to the <a href="#">terms</a>
                </label>
              </div>
            </div>
            <!-- /.col -->
            <div class="col-4">
              <button type="submit" class="btn btn-primary btn-block">{{ __('Register') }}</button>
            </div>
            <!-- /.col -->
          </div>
        </form>
  
        <hr>
         
        <a href="{{ route('merchant.login') }}" class="text-center">{{ __('Login') }}</a>
      </div>
      <!-- /.form-box -->
    </div><!-- /.card -->
  </div>
  <!-- /.register-box -->
  
@endsection
@section('scripts')
<!-- Select2 -->
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>

<script>
$(function () {
   
    $('input').attr('autocomplete','off');
 //Initialize Select2 Elements
$('.select2').select2()
 $('.select2bs4').select2({
      theme: 'bootstrap4'
    })
    $(".add-image").click(function(){ 
          var lsthmtl = $(".clone").html();
          $(".increment").after(lsthmtl);
      });
      $("body").on("click",".remove-image",function(){ 
          $(this).parents(".hdtuto").remove();
      });
  })
   
//Initialize Select2 Elements
</script>
@endsection